/*
 * Decompiled with CFR 0.152.
 */
package tech.fandiful.grpcpacketchannel.impl.server;

import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerMethodDefinition;
import io.grpc.Status;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.fan87.pixelmongo.ui.com.google.protobuf.ByteString;
import me.fan87.pixelmongo.ui.com.google.protobuf.MessageLite;
import org.jetbrains.annotations.NotNull;
import tech.fandiful.grpcpacketchannel.impl.server.GrpcPacketServer;
import tech.fandiful.grpcpacketchannel.packets.PacketTypes;
import tech.fandiful.grpcpacketchannel.proto.CallIdKt;
import tech.fandiful.grpcpacketchannel.proto.Packets;
import tech.fandiful.grpcpacketchannel.proto.S2CPacketCallResponseKt;
import tech.fandiful.grpcpacketchannel.proto.S2CPacketCloseKt;
import tech.fandiful.grpcpacketchannel.proto.S2CPacketHeaderKt;
import tech.fandiful.grpcpacketchannel.utils.GrpcConversionKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0016\u001a\u00020\tH\u0002J\u0016\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010\u001e\u001a\u00020\tJ\u0006\u0010\u001f\u001a\u00020\tJ\u000e\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\bJ\"\u0010\"\u001a\u00020\t2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00142\u0006\u0010#\u001a\u00020\u001bJ\u000e\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Ltech/fandiful/grpcpacketchannel/impl/server/GrpcPacketCallHandler;", "RequestT", "ResponseT", "", "server", "Ltech/fandiful/grpcpacketchannel/impl/server/GrpcPacketServer;", "submitter", "Lkotlin/Function1;", "", "", "callId", "Ljava/util/UUID;", "(Ltech/fandiful/grpcpacketchannel/impl/server/GrpcPacketServer;Lkotlin/jvm/functions/Function1;Ljava/util/UUID;)V", "cancelled", "", "closed", "halfClosed", "listener", "Lio/grpc/ServerCall$Listener;", "method", "Lio/grpc/ServerMethodDefinition;", "started", "checkStarted", "close", "status", "Lio/grpc/Status;", "trailers", "Lio/grpc/Metadata;", "getProtoCallId", "Ltech/fandiful/grpcpacketchannel/proto/Packets$CallId;", "onCancel", "onHalfClose", "onRequest", "request", "onStart", "header", "send", "message", "Lme/fan87/pixelmongo/ui/com/google/protobuf/MessageLite;", "grpc-java-packet-channel"})
@SourceDebugExtension(value={"SMAP\nGrpcPacketCallHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrpcPacketCallHandler.kt\ntech/fandiful/grpcpacketchannel/impl/server/GrpcPacketCallHandler\n+ 2 CallIdKt.kt\ntech/fandiful/grpcpacketchannel/proto/CallIdKtKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 S2CPacketCloseKt.kt\ntech/fandiful/grpcpacketchannel/proto/S2CPacketCloseKtKt\n*L\n1#1,130:1\n10#2:131\n1#3:132\n1#3:134\n10#4:133\n*S KotlinDebug\n*F\n+ 1 GrpcPacketCallHandler.kt\ntech/fandiful/grpcpacketchannel/impl/server/GrpcPacketCallHandler\n*L\n77#1:131\n77#1:132\n108#1:134\n108#1:133\n*E\n"})
public final class GrpcPacketCallHandler<RequestT, ResponseT> {
    @NotNull
    private final GrpcPacketServer server;
    @NotNull
    private final Function1<byte[], Unit> submitter;
    @NotNull
    private final UUID callId;
    private boolean started;
    private boolean cancelled;
    private boolean closed;
    private boolean halfClosed;
    private ServerMethodDefinition<RequestT, ResponseT> method;
    private ServerCall.Listener<RequestT> listener;

    public GrpcPacketCallHandler(@NotNull GrpcPacketServer server, @NotNull Function1<? super byte[], Unit> submitter, @NotNull UUID callId) {
        Intrinsics.checkNotNullParameter(server, "server");
        Intrinsics.checkNotNullParameter(submitter, "submitter");
        Intrinsics.checkNotNullParameter(callId, "callId");
        this.server = server;
        this.submitter = submitter;
        this.callId = callId;
    }

    public final void send(@NotNull MessageLite message) {
        Intrinsics.checkNotNullParameter(message, "message");
        this.submitter.invoke(PacketTypes.INSTANCE.getPacketData(message));
    }

    public final void onStart(@NotNull ServerMethodDefinition<RequestT, ResponseT> method, @NotNull io.grpc.Metadata header) {
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(header, "header");
        this.method = method;
        this.started = true;
        ServerCall.Listener<RequestT> listener = method.getServerCallHandler().startCall(new ServerCall<RequestT, ResponseT>(this, method){
            private int deliverCount;
            final /* synthetic */ GrpcPacketCallHandler<RequestT, ResponseT> this$0;
            final /* synthetic */ ServerMethodDefinition<RequestT, ResponseT> $method;
            {
                this.this$0 = $receiver;
                this.$method = $method;
            }

            public void request(int numMessages) {
                this.deliverCount += numMessages;
            }

            /*
             * WARNING - void declaration
             */
            public void sendHeaders(@NotNull io.grpc.Metadata headers) {
                void $this$sendHeaders_u24lambda_u240;
                S2CPacketHeaderKt.Dsl dsl;
                Intrinsics.checkNotNullParameter(headers, "headers");
                GrpcPacketCallHandler<RequestT, ResponseT> grpcPacketCallHandler2 = this.this$0;
                boolean bl = false;
                Packets.S2CPacketHeader.Builder builder = Packets.S2CPacketHeader.newBuilder();
                Intrinsics.checkNotNullExpressionValue(builder, "newBuilder(...)");
                S2CPacketHeaderKt.Dsl $this$s2CPacketHeader_u24lambda_u240$iv = dsl = S2CPacketHeaderKt.Dsl.Companion._create(builder);
                boolean bl2 = false;
                S2CPacketHeaderKt.Dsl dsl2 = $this$s2CPacketHeader_u24lambda_u240$iv;
                GrpcPacketCallHandler<RequestT, ResponseT> grpcPacketCallHandler3 = this.this$0;
                boolean bl3 = false;
                $this$sendHeaders_u24lambda_u240.setCallId(GrpcPacketCallHandler.access$getProtoCallId(grpcPacketCallHandler2));
                $this$sendHeaders_u24lambda_u240.setHeader(GrpcConversionKt.toPacket(headers));
                grpcPacketCallHandler3.send(dsl._build());
            }

            public void close(@NotNull Status status, @NotNull io.grpc.Metadata trailers) {
                Intrinsics.checkNotNullParameter(status, "status");
                Intrinsics.checkNotNullParameter(trailers, "trailers");
                if (status.isOk()) {
                    ServerCall.Listener listener = GrpcPacketCallHandler.access$getListener$p(this.this$0);
                    if (listener == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("listener");
                        listener = null;
                    }
                    listener.onComplete();
                } else {
                    ServerCall.Listener listener = GrpcPacketCallHandler.access$getListener$p(this.this$0);
                    if (listener == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("listener");
                        listener = null;
                    }
                    listener.onCancel();
                }
                this.this$0.close(status, trailers);
            }

            public boolean isCancelled() {
                return GrpcPacketCallHandler.access$getCancelled$p(this.this$0);
            }

            @NotNull
            public MethodDescriptor<RequestT, ResponseT> getMethodDescriptor() {
                MethodDescriptor<RequestT, ResponseT> methodDescriptor = this.$method.getMethodDescriptor();
                Intrinsics.checkNotNullExpressionValue(methodDescriptor, "getMethodDescriptor(...)");
                return methodDescriptor;
            }

            /*
             * WARNING - void declaration
             */
            public void sendMessage(ResponseT message) {
                void $this$sendMessage_u24lambda_u241;
                S2CPacketCallResponseKt.Dsl dsl;
                GrpcPacketCallHandler<RequestT, ResponseT> grpcPacketCallHandler2 = this.this$0;
                ServerMethodDefinition<RequestT, ResponseT> serverMethodDefinition = this.$method;
                boolean bl = false;
                Packets.S2CPacketCallResponse.Builder builder = Packets.S2CPacketCallResponse.newBuilder();
                Intrinsics.checkNotNullExpressionValue(builder, "newBuilder(...)");
                S2CPacketCallResponseKt.Dsl $this$s2CPacketCallResponse_u24lambda_u240$iv = dsl = S2CPacketCallResponseKt.Dsl.Companion._create(builder);
                boolean bl2 = false;
                S2CPacketCallResponseKt.Dsl dsl2 = $this$s2CPacketCallResponse_u24lambda_u240$iv;
                GrpcPacketCallHandler<RequestT, ResponseT> grpcPacketCallHandler3 = this.this$0;
                boolean bl3 = false;
                $this$sendMessage_u24lambda_u241.setCallId(GrpcPacketCallHandler.access$getProtoCallId(grpcPacketCallHandler2));
                InputStream inputStream2 = serverMethodDefinition.getMethodDescriptor().streamResponse(message);
                Intrinsics.checkNotNullExpressionValue(inputStream2, "streamResponse(...)");
                ByteString byteString = ByteString.copyFrom(ByteStreamsKt.readBytes(inputStream2));
                Intrinsics.checkNotNullExpressionValue(byteString, "copyFrom(...)");
                $this$sendMessage_u24lambda_u241.setData(byteString);
                grpcPacketCallHandler3.send(dsl._build());
            }
        }, header);
        Intrinsics.checkNotNullExpressionValue(listener, "startCall(...)");
        this.listener = listener;
    }

    private final Packets.CallId getProtoCallId() {
        CallIdKt.Dsl dsl;
        boolean bl = false;
        Packets.CallId.Builder builder = Packets.CallId.newBuilder();
        Intrinsics.checkNotNullExpressionValue(builder, "newBuilder(...)");
        CallIdKt.Dsl $this$callId_u24lambda_u240$iv = dsl = CallIdKt.Dsl.Companion._create(builder);
        boolean bl2 = false;
        CallIdKt.Dsl $this$getProtoCallId_u24lambda_u240 = $this$callId_u24lambda_u240$iv;
        boolean bl3 = false;
        $this$getProtoCallId_u24lambda_u240.setMost(this.callId.getMostSignificantBits());
        $this$getProtoCallId_u24lambda_u240.setLeast(this.callId.getLeastSignificantBits());
        return dsl._build();
    }

    public final void onCancel() {
        this.server.getExecutor$grpc_java_packet_channel().execute(() -> GrpcPacketCallHandler.onCancel$lambda$1(this));
        Status status = Status.CANCELLED;
        Intrinsics.checkNotNullExpressionValue(status, "CANCELLED");
        this.close(status, new io.grpc.Metadata());
        this.cancelled = true;
    }

    public final void onRequest(@NotNull byte[] request2) {
        Intrinsics.checkNotNullParameter(request2, "request");
        this.checkStarted();
        ServerMethodDefinition<RequestT, ResponseT> serverMethodDefinition = this.method;
        if (serverMethodDefinition == null) {
            Intrinsics.throwUninitializedPropertyAccessException("method");
            serverMethodDefinition = null;
        }
        RequestT query2 = serverMethodDefinition.getMethodDescriptor().parseRequest(new ByteArrayInputStream(request2));
        this.server.getExecutor$grpc_java_packet_channel().execute(() -> GrpcPacketCallHandler.onRequest$lambda$2(this, query2));
    }

    public final void onHalfClose() {
        this.server.getExecutor$grpc_java_packet_channel().execute(() -> GrpcPacketCallHandler.onHalfClose$lambda$3(this));
        this.halfClosed = true;
    }

    /*
     * WARNING - void declaration
     */
    public final void close(@NotNull Status status, @NotNull io.grpc.Metadata trailers) {
        void $this$close_u24lambda_u244;
        S2CPacketCloseKt.Dsl dsl;
        Intrinsics.checkNotNullParameter(status, "status");
        Intrinsics.checkNotNullParameter(trailers, "trailers");
        boolean bl = false;
        Packets.S2CPacketClose.Builder builder = Packets.S2CPacketClose.newBuilder();
        Intrinsics.checkNotNullExpressionValue(builder, "newBuilder(...)");
        S2CPacketCloseKt.Dsl $this$s2CPacketClose_u24lambda_u240$iv = dsl = S2CPacketCloseKt.Dsl.Companion._create(builder);
        boolean bl2 = false;
        S2CPacketCloseKt.Dsl dsl2 = $this$s2CPacketClose_u24lambda_u240$iv;
        GrpcPacketCallHandler grpcPacketCallHandler2 = this;
        boolean bl3 = false;
        $this$close_u24lambda_u244.setCallId(this.getProtoCallId());
        $this$close_u24lambda_u244.setStatusCode(status.getCode().value());
        $this$close_u24lambda_u244.setTrailers(GrpcConversionKt.toPacket(trailers));
        grpcPacketCallHandler2.send(dsl._build());
        this.server.getCalls$grpc_java_packet_channel().remove(this.callId);
        this.closed = true;
    }

    private final void checkStarted() {
        if (!this.started) {
            throw new IllegalStateException("The call hasn't started");
        }
        if (this.closed) {
            throw new IllegalStateException("The call has been closed");
        }
        if (this.cancelled) {
            throw new IllegalStateException("The call has been cancelled");
        }
    }

    private static final void onCancel$lambda$1(GrpcPacketCallHandler this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        ServerCall.Listener listener = this$0.listener;
        if (listener == null) {
            Intrinsics.throwUninitializedPropertyAccessException("listener");
            listener = null;
        }
        listener.onCancel();
    }

    private static final void onRequest$lambda$2(GrpcPacketCallHandler this$0, Object $query) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        ServerCall.Listener listener = this$0.listener;
        if (listener == null) {
            Intrinsics.throwUninitializedPropertyAccessException("listener");
            listener = null;
        }
        listener.onMessage($query);
    }

    private static final void onHalfClose$lambda$3(GrpcPacketCallHandler this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        ServerCall.Listener listener = this$0.listener;
        if (listener == null) {
            Intrinsics.throwUninitializedPropertyAccessException("listener");
            listener = null;
        }
        listener.onHalfClose();
    }

    public static final /* synthetic */ ServerCall.Listener access$getListener$p(GrpcPacketCallHandler $this) {
        return $this.listener;
    }

    public static final /* synthetic */ boolean access$getCancelled$p(GrpcPacketCallHandler $this) {
        return $this.cancelled;
    }

    public static final /* synthetic */ Packets.CallId access$getProtoCallId(GrpcPacketCallHandler $this) {
        return $this.getProtoCallId();
    }
}

