/*
 * Decompiled with CFR 0.152.
 */
package tech.fandiful.grpcpacketchannel.impl.server;

import io.grpc.BindableService;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.fandiful.grpcpacketchannel.WrappedPacketHandler;
import tech.fandiful.grpcpacketchannel.impl.server.GrpcPacketCallHandler;
import tech.fandiful.grpcpacketchannel.packets.PacketTypes;
import tech.fandiful.grpcpacketchannel.proto.Packets;
import tech.fandiful.grpcpacketchannel.utils.GrpcConversionKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0019J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0006H\u0002J\u000e\u0010!\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0006R(\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\"\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00170\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00190\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ltech/fandiful/grpcpacketchannel/impl/server/GrpcPacketServer;", "", "maxPacketSize", "", "dataSubmitter", "Lkotlin/Function1;", "", "", "(ILkotlin/jvm/functions/Function1;)V", "calls", "Ljava/util/HashMap;", "Ljava/util/UUID;", "Ltech/fandiful/grpcpacketchannel/impl/server/GrpcPacketCallHandler;", "getCalls$grpc_java_packet_channel", "()Ljava/util/HashMap;", "executor", "Ljava/util/concurrent/Executor;", "getExecutor$grpc_java_packet_channel", "()Ljava/util/concurrent/Executor;", "setExecutor$grpc_java_packet_channel", "(Ljava/util/concurrent/Executor;)V", "methods", "", "Lio/grpc/ServerMethodDefinition;", "services", "Lio/grpc/ServerServiceDefinition;", "wrapper", "Ltech/fandiful/grpcpacketchannel/WrappedPacketHandler;", "addService", "service", "Lio/grpc/BindableService;", "readAndHandleData", "data", "submitData", "grpc-java-packet-channel"})
public final class GrpcPacketServer {
    @NotNull
    private final Function1<byte[], Unit> dataSubmitter;
    @NotNull
    private final HashMap<String, ServerServiceDefinition> services;
    @NotNull
    private final HashMap<String, ServerMethodDefinition<?, ?>> methods;
    @NotNull
    private final HashMap<UUID, GrpcPacketCallHandler<?, ?>> calls;
    @NotNull
    private final WrappedPacketHandler wrapper;
    @NotNull
    private Executor executor;

    public GrpcPacketServer(int maxPacketSize, @NotNull Function1<? super byte[], Unit> dataSubmitter) {
        Intrinsics.checkNotNullParameter(dataSubmitter, "dataSubmitter");
        this.dataSubmitter = dataSubmitter;
        this.services = new HashMap();
        this.methods = new HashMap();
        this.calls = new HashMap();
        this.wrapper = new WrappedPacketHandler(maxPacketSize, 10000L, (Function1<? super byte[], Unit>)new Function1<byte[], Unit>(this){
            final /* synthetic */ GrpcPacketServer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull byte[] it) {
                Intrinsics.checkNotNullParameter(it, "it");
                GrpcPacketServer.access$getDataSubmitter$p(this.this$0).invoke(it);
            }
        }, (Function1<? super byte[], Unit>)new Function1<byte[], Unit>(this){
            final /* synthetic */ GrpcPacketServer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull byte[] it) {
                Intrinsics.checkNotNullParameter(it, "it");
                GrpcPacketServer.access$readAndHandleData(this.this$0, it);
            }
        });
        this.executor = GrpcPacketServer::executor$lambda$0;
    }

    public /* synthetic */ GrpcPacketServer(int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = Integer.MAX_VALUE;
        }
        this(n, function1);
    }

    @NotNull
    public final HashMap<UUID, GrpcPacketCallHandler<?, ?>> getCalls$grpc_java_packet_channel() {
        return this.calls;
    }

    @NotNull
    public final Executor getExecutor$grpc_java_packet_channel() {
        return this.executor;
    }

    public final void setExecutor$grpc_java_packet_channel(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter(executor, "<set-?>");
        this.executor = executor;
    }

    public final void submitData(@NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        this.wrapper.submit(data2);
    }

    private final void readAndHandleData(byte[] data2) {
        Packets.PacketData packetData = Packets.PacketData.parser().parseFrom(data2);
        PacketTypes.PacketType<?> packetType = PacketTypes.INSTANCE.getPackets().get(packetData.getPacketType());
        if (packetType == null) {
            return;
        }
        PacketTypes.PacketType<?> packetType2 = packetType;
        Object packet = packetType2.getRead().parseFrom(packetData.getData());
        Object obj = packet;
        if (obj instanceof Packets.C2SPacketCallStart) {
            UUID callId = new UUID(((Packets.C2SPacketCallStart)packet).getCallId().getMost(), ((Packets.C2SPacketCallStart)packet).getCallId().getLeast());
            GrpcPacketCallHandler grpcPacketCallHandler2 = new GrpcPacketCallHandler(this, (Function1<? super byte[], Unit>)new Function1<byte[], Unit>(this){
                final /* synthetic */ GrpcPacketServer this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull byte[] it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    GrpcPacketServer.access$getWrapper$p(this.this$0).send(it);
                }
            }, callId);
            ServerMethodDefinition<?, ?> method = this.methods.get(((Packets.C2SPacketCallStart)packet).getMethodFullName());
            if (method == null) {
                Status status = Status.UNIMPLEMENTED;
                Intrinsics.checkNotNullExpressionValue(status, "UNIMPLEMENTED");
                grpcPacketCallHandler2.close(status, new io.grpc.Metadata());
                return;
            }
            ((Map)this.calls).put(callId, grpcPacketCallHandler2);
            Packets.Metadata metadata = ((Packets.C2SPacketCallStart)packet).getHeader();
            Intrinsics.checkNotNullExpressionValue(metadata, "getHeader(...)");
            grpcPacketCallHandler2.onStart(method, GrpcConversionKt.toGrpc(metadata));
        } else if (obj instanceof Packets.C2SPacketCallCancel) {
            GrpcPacketCallHandler<?, ?> grpcPacketCallHandler3 = this.calls.get(new UUID(((Packets.C2SPacketCallCancel)packet).getCallId().getMost(), ((Packets.C2SPacketCallCancel)packet).getCallId().getLeast()));
            if (grpcPacketCallHandler3 == null) {
                return;
            }
            GrpcPacketCallHandler<?, ?> call = grpcPacketCallHandler3;
            call.onCancel();
        } else if (obj instanceof Packets.C2SPacketCallRequest) {
            GrpcPacketCallHandler<?, ?> grpcPacketCallHandler4 = this.calls.get(new UUID(((Packets.C2SPacketCallRequest)packet).getCallId().getMost(), ((Packets.C2SPacketCallRequest)packet).getCallId().getLeast()));
            if (grpcPacketCallHandler4 == null) {
                return;
            }
            GrpcPacketCallHandler<?, ?> call = grpcPacketCallHandler4;
            byte[] byArray = ((Packets.C2SPacketCallRequest)packet).getData().toByteArray();
            Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
            call.onRequest(byArray);
        } else if (obj instanceof Packets.C2SPacketHalfClosed) {
            GrpcPacketCallHandler<?, ?> grpcPacketCallHandler5 = this.calls.get(new UUID(((Packets.C2SPacketHalfClosed)packet).getCallId().getMost(), ((Packets.C2SPacketHalfClosed)packet).getCallId().getLeast()));
            if (grpcPacketCallHandler5 == null) {
                return;
            }
            GrpcPacketCallHandler<?, ?> call = grpcPacketCallHandler5;
            call.onHalfClose();
        }
    }

    @NotNull
    public final GrpcPacketServer addService(@NotNull ServerServiceDefinition service) {
        Intrinsics.checkNotNullParameter(service, "service");
        Map map2 = this.services;
        String string = service.getServiceDescriptor().getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        map2.put(string, service);
        for (ServerMethodDefinition serverMethodDefinition : service.getMethods()) {
            String string2;
            Map map3 = this.methods;
            Intrinsics.checkNotNullExpressionValue(serverMethodDefinition.getMethodDescriptor().getFullMethodName(), "getFullMethodName(...)");
            Intrinsics.checkNotNull(serverMethodDefinition);
            ServerMethodDefinition serverMethodDefinition2 = serverMethodDefinition;
            map3.put(string2, serverMethodDefinition2);
        }
        return this;
    }

    @NotNull
    public final GrpcPacketServer addService(@NotNull BindableService service) {
        Intrinsics.checkNotNullParameter(service, "service");
        ServerServiceDefinition serverServiceDefinition = service.bindService();
        Intrinsics.checkNotNullExpressionValue(serverServiceDefinition, "bindService(...)");
        this.addService(serverServiceDefinition);
        return this;
    }

    @NotNull
    public final GrpcPacketServer executor(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter(executor, "executor");
        this.executor = executor;
        return this;
    }

    private static final void executor$lambda$0(Runnable it) {
        it.run();
    }

    public static final /* synthetic */ WrappedPacketHandler access$getWrapper$p(GrpcPacketServer $this) {
        return $this.wrapper;
    }

    public static final /* synthetic */ Function1 access$getDataSubmitter$p(GrpcPacketServer $this) {
        return $this.dataSubmitter;
    }

    public static final /* synthetic */ void access$readAndHandleData(GrpcPacketServer $this, byte[] data2) {
        $this.readAndHandleData(data2);
    }
}

