/*
 * Decompiled with CFR 0.152.
 */
package tech.fandiful.javamodular;

public abstract class AbstractModule {
    private boolean loaded;

    public void load() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        this.onLoad();
    }

    public void unload() {
        if (!this.loaded) {
            return;
        }
        this.loaded = false;
        this.onUnload();
    }

    protected abstract void onLoad();

    protected abstract void onUnload();

    public void ensureLoaded() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("the module is not loaded, therefore the operation is not supported");
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }
}

