/*
 * Decompiled with CFR 0.152.
 */
package tech.fandiful.javamodular.save;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import tech.fandiful.javamodular.AbstractModule;
import tech.fandiful.javamodular.save.ISavable;

public class LocalSaveManager
extends AbstractModule
implements ISavable<JsonObject> {
    private final Map<String, ISavable<?>> saveList = new LinkedHashMap();

    public <T extends ISavable<?>> T registerSavable(String key, T value) {
        this.saveList.put(key, value);
        return value;
    }

    @Override
    protected void onLoad() {
    }

    @Override
    protected void onUnload() {
    }

    @Override
    public JsonObject saveData() {
        JsonObject object = new JsonObject();
        for (Map.Entry<String, ISavable<?>> entry2 : this.saveList.entrySet()) {
            String key = entry2.getKey();
            ISavable<?> savable = entry2.getValue();
            Object value = savable.saveData();
            if (value == null) continue;
            if (savable.getElementType().isAssignableFrom(value.getClass())) {
                object.add(key, value);
                continue;
            }
            throw new ClassCastException("Saved value does not match its type: " + savable.getElementType().getSimpleName() + ", but got " + value.getClass().getSimpleName() + " (" + key + ")");
        }
        return object;
    }

    @Override
    public void loadData(JsonObject object) {
        if (object == null) {
            return;
        }
        for (Map.Entry<String, ISavable<?>> entry2 : this.saveList.entrySet()) {
            String key = entry2.getKey();
            ISavable<?> savable = entry2.getValue();
            JsonElement value = object.get(key);
            if (value == null || !savable.getElementType().isAssignableFrom(value.getClass())) continue;
            ISavable<?> typedSavable = savable;
            typedSavable.loadData(value);
        }
    }

    @Override
    public Class<JsonObject> getElementType() {
        return JsonObject.class;
    }

    public Map<String, ISavable<?>> getSaveList() {
        return this.saveList;
    }
}

