/*
 * Decompiled with CFR 0.152.
 */
package tech.fandiful.javamodular.settings;

import com.google.gson.JsonElement;
import java.util.concurrent.atomic.AtomicReference;
import tech.fandiful.javamodular.EventTarget;
import tech.fandiful.javamodular.save.ISavable;
import tech.fandiful.javamodular.settings.InvalidSettingValueException;
import tech.fandiful.javamodular.settings.SettingValueChangeEvent;

public abstract class AbstractSetting<T, S extends JsonElement>
implements ISavable<S> {
    private final T defaultValue;
    private boolean defaultSet = false;
    private final EventTarget<SettingValueChangeEvent<T>> valueChangeEvent = new EventTarget();
    private final AtomicReference<T> value = new AtomicReference<Object>(null);

    public AbstractSetting(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void resetDefault() {
        try {
            this.setValue(this.defaultValue);
        }
        catch (InvalidSettingValueException e) {
            e.printStackTrace();
        }
    }

    public void setValue(T value) throws InvalidSettingValueException {
        this.value.set(this.valueChangeEvent.fire(new SettingValueChangeEvent<T>(this.value.get(), value)).getNewValue());
        this.defaultSet = true;
    }

    public T getValue() {
        if (!this.defaultSet) {
            this.defaultSet = true;
            this.resetDefault();
        }
        return this.value.get();
    }

    public abstract S toJson(T var1);

    public abstract T fromJson(S var1);

    @Override
    public S saveData() {
        return this.toJson(this.getValue());
    }

    @Override
    public void loadData(S object) {
        try {
            T v = this.fromJson(object);
            if (v == null) {
                this.resetDefault();
                return;
            }
            this.setValue(v);
        }
        catch (InvalidSettingValueException e) {
            e.printStackTrace();
            this.resetDefault();
        }
    }

    public EventTarget<SettingValueChangeEvent<T>> valueChangeEvent() {
        return this.valueChangeEvent;
    }
}

