/*
 * Decompiled with CFR 0.152.
 */
package tech.fandiful.javamodular.settings;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import tech.fandiful.javamodular.save.ISavable;
import tech.fandiful.javamodular.save.LocalSaveManager;
import tech.fandiful.javamodular.settings.AbstractSetting;

public class NamedSettings
implements ISavable<JsonObject> {
    private final Map<String, AbstractSetting<?, ?>> settings = new LinkedHashMap();
    private final Map<String, String> settingsDisplay = new HashMap<String, String>();
    private final LocalSaveManager settingsSaveManager = new LocalSaveManager();

    @Override
    public JsonObject saveData() {
        return this.settingsSaveManager.saveData();
    }

    @Override
    public void loadData(JsonObject object) {
        this.settingsSaveManager.loadData(object);
    }

    public <T extends AbstractSetting<?, ?>> T registerSetting(String name, T setting) {
        return this.registerSetting(name, name, setting);
    }

    public <T extends AbstractSetting<?, ?>> T registerSetting(String name, String displayName, T setting) {
        this.settings.put(name, setting);
        this.settingsDisplay.put(name, displayName);
        this.settingsSaveManager.registerSavable(name, setting);
        return setting;
    }

    @Override
    public Class<JsonObject> getElementType() {
        return this.settingsSaveManager.getElementType();
    }

    public void transferDataTo(NamedSettings other) {
        if (other.settings.size() == this.settings.size() && !other.settings.keySet().containsAll(this.settings.keySet())) {
            throw new IllegalArgumentException("the other settings does not match the current one");
        }
        other.loadData(this.saveData());
    }

    public Map<String, AbstractSetting<?, ?>> getSettings() {
        return this.settings;
    }

    public Map<String, String> getSettingsDisplay() {
        return this.settingsDisplay;
    }

    public LocalSaveManager getSettingsSaveManager() {
        return this.settingsSaveManager;
    }
}

