/*
 * Decompiled with CFR 0.152.
 */
package tech.fandiful.javamodular.settings.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import tech.fandiful.javamodular.settings.AbstractSetting;

public class CustomListSetting<T>
extends AbstractSetting<List<T>, JsonArray> {
    private final Function<JsonElement, T> deserializer;
    private final Function<T, JsonElement> serializer;

    public CustomListSetting(Function<JsonElement, T> deserializer, Function<T, JsonElement> serializer2) {
        super(new ArrayList());
        this.serializer = serializer2;
        this.deserializer = deserializer;
    }

    public CustomListSetting(List<T> defaultValue, Function<JsonElement, T> deserializer, Function<T, JsonElement> serializer2) {
        super(new ArrayList<T>(defaultValue));
        this.serializer = serializer2;
        this.deserializer = deserializer;
    }

    @Override
    public Class<JsonArray> getElementType() {
        return JsonArray.class;
    }

    @Override
    public JsonArray toJson(List<T> value) {
        JsonArray array = new JsonArray();
        for (Object t2 : (List)this.getValue()) {
            JsonElement element = this.serializer.apply(t2);
            if (element == null) continue;
            array.add(element);
        }
        return array;
    }

    @Override
    public List<T> fromJson(JsonArray value) {
        ArrayList<T> values2 = new ArrayList<T>();
        for (JsonElement jsonElement : value) {
            T element = this.deserializer.apply(jsonElement);
            if (element == null) continue;
            values2.add(element);
        }
        return values2;
    }
}

