/*
 * Decompiled with CFR 0.152.
 */
package tech.fandiful.javamodular.settings.impl;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import tech.fandiful.javamodular.settings.AbstractSetting;
import tech.fandiful.javamodular.settings.enumsetting.ConfigurableEnum;

public class EnumSetting<T extends Enum<T>, S extends JsonElement>
extends AbstractSetting<T, S> {
    private final List<T> values;
    private final Class<S> elementType;
    private final boolean dropdown;

    public EnumSetting(T defaultValue, boolean dropdown) {
        super(defaultValue);
        this.elementType = ((ConfigurableEnum)((Object)((Enum)Objects.requireNonNull(defaultValue)))).getElementType();
        this.values = new ArrayList<T>();
        for (Enum enumConstant : (Enum[])defaultValue.getClass().getEnumConstants()) {
            this.values.add(enumConstant);
        }
        this.dropdown = dropdown;
    }

    @Override
    public S toJson(T value) {
        return (S)((ConfigurableEnum)value).save();
    }

    @Override
    public T fromJson(S value) {
        return (T)((Enum)this.values.stream().filter(it -> ((ConfigurableEnum)((Object)it)).matches(value)).findFirst().orElse(null));
    }

    @Override
    public Class<S> getElementType() {
        return this.elementType;
    }

    public List<T> getValues() {
        return this.values;
    }

    public boolean isDropdown() {
        return this.dropdown;
    }
}

