/*
 * Decompiled with CFR 0.152.
 */
package tech.fandiful.javamodular.settings.impl.color;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import tech.fandiful.javamodular.settings.AbstractSetting;

public class AlphaColorSetting
extends AbstractSetting<Color, JsonObject> {
    public AlphaColorSetting(Color defaultValue) {
        super(defaultValue);
    }

    @Override
    public JsonObject toJson(Color value) {
        JsonObject object = new JsonObject();
        object.addProperty("r", (Number)value.getRed());
        object.addProperty("g", (Number)value.getGreen());
        object.addProperty("b", (Number)value.getBlue());
        object.addProperty("a", (Number)value.getAlpha());
        return object;
    }

    @Override
    public Color fromJson(JsonObject value) {
        JsonElement redElement = value.get("r");
        JsonElement greenElement = value.get("g");
        JsonElement blueElement = value.get("b");
        JsonElement alphaElement = value.get("a");
        if (redElement != null && greenElement != null && blueElement != null && alphaElement != null) {
            return new Color(redElement.getAsInt(), greenElement.getAsInt(), blueElement.getAsInt(), alphaElement.getAsInt());
        }
        return null;
    }

    @Override
    public Class<JsonObject> getElementType() {
        return JsonObject.class;
    }
}

