/*
 * Decompiled with CFR 0.152.
 */
package tech.fandiful.javamodular.settings.impl.color;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import tech.fandiful.javamodular.settings.AbstractSetting;

public class ColorSetting
extends AbstractSetting<Color, JsonObject> {
    public ColorSetting(Color defaultValue) {
        super(defaultValue);
    }

    @Override
    public JsonObject toJson(Color value) {
        JsonObject object = new JsonObject();
        object.addProperty("r", (Number)value.getRed());
        object.addProperty("g", (Number)value.getGreen());
        object.addProperty("b", (Number)value.getBlue());
        return object;
    }

    @Override
    public Color fromJson(JsonObject value) {
        JsonElement redElement = value.get("r");
        JsonElement greenElement = value.get("g");
        JsonElement blueElement = value.get("b");
        if (redElement != null && greenElement != null && blueElement != null) {
            return new Color(redElement.getAsInt(), greenElement.getAsInt(), blueElement.getAsInt());
        }
        return null;
    }

    @Override
    public Class<JsonObject> getElementType() {
        return JsonObject.class;
    }
}

