/*
 * Decompiled with CFR 0.152.
 */
package tech.fandiful.javamodular.settings.impl.number;

import com.google.gson.JsonPrimitive;
import java.util.Objects;
import tech.fandiful.javamodular.settings.AbstractSetting;
import tech.fandiful.javamodular.settings.InvalidSettingValueException;

public abstract class NumberSetting<T extends Number>
extends AbstractSetting<T, JsonPrimitive> {
    private final T minValue;
    private final T maxValue;
    private final T step;

    public NumberSetting(T defaultValue, T minValue, T maxValue, T step) {
        super(defaultValue);
        this.minValue = (Number)Objects.requireNonNull(minValue);
        this.maxValue = (Number)Objects.requireNonNull(maxValue);
        if (((Comparable)this.minValue).compareTo(this.maxValue) >= 0) {
            throw new IllegalArgumentException("minValue > maxValue");
        }
        this.step = (Number)Objects.requireNonNull(step);
    }

    public boolean valueInRange(T value) {
        return ((Comparable)this.minValue).compareTo(value) <= 0 && ((Comparable)this.maxValue).compareTo(value) >= 0;
    }

    @Override
    public void setValue(T value) throws InvalidSettingValueException {
        if (!this.valueInRange((Number)Objects.requireNonNull(value))) {
            throw new InvalidSettingValueException("Number value out of range");
        }
        super.setValue(this.snapToStep(value));
    }

    public T snapToStep(T input) {
        double value;
        if (((Number)this.step).doubleValue() > (double)0.01f) {
            double valueFromBegin = ((Number)input).doubleValue() - ((Number)this.minValue).doubleValue();
            value = ((Number)this.step).doubleValue() * (double)Math.round(valueFromBegin / ((Number)this.step).doubleValue());
            value += ((Number)this.minValue).doubleValue();
        } else {
            value = ((Number)input).doubleValue();
        }
        return this.convertFromNumber(value);
    }

    public void setNumberValue(Number value) throws InvalidSettingValueException {
        this.setValue(this.convertFromNumber(value));
    }

    @Override
    public JsonPrimitive toJson(T value) {
        return new JsonPrimitive((Number)this.getValue());
    }

    @Override
    public T fromJson(JsonPrimitive value) {
        return this.convertFromNumber(value.getAsNumber());
    }

    protected abstract T convertFromNumber(Number var1);

    @Override
    public Class<JsonPrimitive> getElementType() {
        return JsonPrimitive.class;
    }

    public T minValue() {
        return this.minValue;
    }

    public T maxValue() {
        return this.maxValue;
    }

    public T step() {
        return this.step;
    }
}

