/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.function.UnaryOperator;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public final class BetterSprintingConfig {
    private static BetterSprintingConfig instance;
    private ModConfig config;
    private boolean isNew = false;

    public static void initialize(ModConfig.Type type, ForgeConfigSpec spec, String suffix) {
        instance = new BetterSprintingConfig();
        String fileName = "bettersprinting-" + suffix + ".toml";
        ModLoadingContext.get().registerConfig(type, spec, fileName);
        if (Files.notExists(Paths.get("config", fileName), new LinkOption[0])) {
            BetterSprintingConfig.instance.isNew = true;
        }
        FMLJavaModLoadingContext.get().getModEventBus().addListener(instance::onConfigLoaded);
    }

    private BetterSprintingConfig() {
    }

    private void onConfigLoaded(ModConfig.Loading e) {
        this.config = e.getConfig();
    }

    public static boolean isNew() {
        return BetterSprintingConfig.instance.isNew;
    }

    public static void save() {
        BetterSprintingConfig.instance.config.save();
    }

    public static <T> void set(ForgeConfigSpec.ConfigValue<T> property, T value) {
        BetterSprintingConfig.instance.config.getConfigData().set(property.getPath(), value);
    }

    public static <T> void update(ForgeConfigSpec.ConfigValue<T> property, UnaryOperator<T> func) {
        BetterSprintingConfig.set(property, func.apply(property.get()));
    }
}

