/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.client.gui;

import chylex.bettersprinting.BetterSprintingConfig;
import chylex.bettersprinting.client.ClientModManager;
import chylex.bettersprinting.client.ClientSettings;
import chylex.bettersprinting.client.gui.GuiButton;
import chylex.bettersprinting.client.gui.GuiButtonCustomInput;
import chylex.bettersprinting.client.gui.GuiButtonInputBinding;
import chylex.bettersprinting.client.gui.GuiButtonInputOption;
import chylex.bettersprinting.client.input.SprintKeyMode;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ControlsScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.settings.KeyModifier;

@OnlyIn(value=Dist.CLIENT)
public class GuiSprint
extends Screen {
    private static final Minecraft mc = Minecraft.func_71410_x();
    public static boolean openedControlsFromSprintMenu;
    private final Screen parentScreen;
    private Button btnSprintMode;
    private GuiButtonInputOption btnDoubleTap;
    private GuiButtonInputOption btnAutoJump;
    private GuiButtonInputOption btnFlyBoost;
    private GuiButtonInputOption btnFlyOnGround;
    private GuiButtonInputOption btnAllDirs;
    private GuiButtonInputOption btnDisableMod;
    private GuiButtonInputBinding selectedBinding;

    public GuiSprint(Screen parentScreen) {
        super((ITextComponent)new StringTextComponent("Better Sprinting"));
        this.parentScreen = parentScreen;
    }

    protected void func_231160_c_() {
        this.field_230710_m_.clear();
        int left = this.field_230708_k_ / 2 - 155;
        int top = this.field_230709_l_ / 6;
        for (int index = 0; index < ClientModManager.keyBindings.length; ++index) {
            this.func_230480_a_((Widget)new GuiButtonInputBinding(left + 160 * (index % 2), top + 24 * (index / 2), ClientModManager.keyBindings[index], this::onBindingClicked));
        }
        this.btnSprintMode = (Button)this.func_230480_a_((Widget)new GuiButton(left - 50, top, 48, "", this.onSettingClicked(() -> BetterSprintingConfig.update(ClientSettings.sprintKeyMode, SprintKeyMode::next))));
        this.btnDoubleTap = (GuiButtonInputOption)this.func_230480_a_((Widget)new GuiButtonInputOption(left, top + 60, "bs.doubleTapping", this.onSettingClicked(() -> {
            if (!((Boolean)ClientSettings.disableMod.get()).booleanValue()) {
                BetterSprintingConfig.update(ClientSettings.enableDoubleTap, value -> value == false);
            }
        })));
        this.btnAllDirs = (GuiButtonInputOption)this.func_230480_a_((Widget)new GuiButtonInputOption(left + 160, top + 60, "bs.runAllDirs", this.onSettingClicked(() -> {
            if (ClientModManager.Feature.RUN_IN_ALL_DIRS.isAvailable()) {
                BetterSprintingConfig.update(ClientSettings.enableAllDirs, value -> value == false);
            }
        })));
        this.btnFlyBoost = (GuiButtonInputOption)this.func_230480_a_((Widget)new GuiButtonInputOption(left, top + 84, "bs.flyBoost", this.onSettingClicked(() -> {
            if (ClientModManager.Feature.FLY_BOOST.isAvailable()) {
                BetterSprintingConfig.update(ClientSettings.flySpeedBoost, value -> (value + 1) % 8);
            }
        })));
        this.btnFlyOnGround = (GuiButtonInputOption)this.func_230480_a_((Widget)new GuiButtonInputOption(left + 160, top + 84, "bs.flyOnGround", this.onSettingClicked(() -> {
            if (ClientModManager.Feature.FLY_ON_GROUND.isAvailable()) {
                BetterSprintingConfig.update(ClientSettings.flyOnGround, value -> value == false);
            }
        })));
        this.btnDisableMod = (GuiButtonInputOption)this.func_230480_a_((Widget)new GuiButtonInputOption(left + 160, top + 108, "bs.disableMod", this.onSettingClicked(() -> {
            if (ClientModManager.canManuallyEnableMod()) {
                BetterSprintingConfig.update(ClientSettings.disableMod, value -> value == false);
                this.updateButtonState();
            }
        })));
        this.btnAutoJump = (GuiButtonInputOption)this.func_230480_a_((Widget)new GuiButtonInputOption(left, top + 108, "bs.autoJump", this.onSettingClicked(() -> {
            GuiSprint.mc.field_71474_y.field_189989_R = !GuiSprint.mc.field_71474_y.field_189989_R;
            GuiSprint.mc.field_71474_y.func_74303_b();
        })));
        this.func_230480_a_((Widget)new GuiButton(this.field_230708_k_ / 2 - 100, top + 168, this.parentScreen == null ? 98 : 200, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), this::onClickedDone));
        if (this.parentScreen == null) {
            this.func_230480_a_((Widget)new GuiButton(this.field_230708_k_ / 2 + 2, top + 168, 98, I18n.func_135052_a((String)"options.controls", (Object[])new Object[0]), this::onClickedControls));
        }
        this.updateButtonState();
        this.updateButtonText();
    }

    private void updateButtonState() {
        for (Widget button : this.field_230710_m_) {
            KeyBinding binding;
            if (!(button instanceof GuiButtonInputBinding) || (binding = ((GuiButtonInputBinding)button).binding) != ClientModManager.keyBindSprintToggle && binding != ClientModManager.keyBindSneakToggle) continue;
            button.field_230693_o_ = !ClientModManager.isModDisabled();
        }
        this.btnSprintMode.field_230693_o_ = !ClientModManager.isModDisabled();
        this.btnDoubleTap.field_230693_o_ = !ClientModManager.isModDisabled();
        this.btnAllDirs.field_230693_o_ = ClientModManager.Feature.RUN_IN_ALL_DIRS.isAvailable();
        this.btnFlyBoost.field_230693_o_ = ClientModManager.Feature.FLY_BOOST.isAvailable();
        this.btnFlyOnGround.field_230693_o_ = ClientModManager.Feature.FLY_ON_GROUND.isAvailable();
        this.btnDisableMod.field_230693_o_ = ClientModManager.canManuallyEnableMod();
    }

    private void updateButtonText() {
        this.btnSprintMode.func_238482_a_((ITextComponent)(ClientModManager.isModDisabled() ? SprintKeyMode.TAP : (SprintKeyMode)((Object)ClientSettings.sprintKeyMode.get())).translationKey);
        this.btnDoubleTap.setTitleKey(ClientModManager.isModDisabled() ? "gui.unavailable" : ((Boolean)ClientSettings.enableDoubleTap.get() != false ? "gui.enabled" : "gui.disabled"));
        this.btnFlyBoost.setTitleKey(ClientModManager.Feature.FLY_BOOST.isAvailable() ? ((Integer)ClientSettings.flySpeedBoost.get() == 0 ? "gui.disabled" : (Integer)ClientSettings.flySpeedBoost.get() + 1 + "x") : "gui.unavailable");
        this.btnFlyOnGround.setTitleKey(ClientModManager.Feature.FLY_ON_GROUND.isAvailable() ? (((Boolean)ClientSettings.flyOnGround.get()).booleanValue() ? "gui.enabled" : "gui.disabled") : "gui.unavailable");
        this.btnAllDirs.setTitleKey(ClientModManager.Feature.RUN_IN_ALL_DIRS.isAvailable() ? (((Boolean)ClientSettings.enableAllDirs.get()).booleanValue() ? "gui.enabled" : "gui.disabled") : "gui.unavailable");
        this.btnDisableMod.setTitleKey(ClientModManager.isModDisabled() ? "gui.yes" : "gui.no");
        this.btnAutoJump.setTitleKey(GuiSprint.mc.field_71474_y.field_189989_R ? "gui.yes" : "gui.no");
    }

    private void onClickedControls() {
        openedControlsFromSprintMenu = true;
        mc.func_147108_a((Screen)new ControlsScreen((Screen)this, GuiSprint.mc.field_71474_y));
        openedControlsFromSprintMenu = false;
        BetterSprintingConfig.save();
    }

    private void onClickedDone() {
        mc.func_147108_a(this.parentScreen);
        BetterSprintingConfig.save();
    }

    private Runnable onSettingClicked(Runnable callback) {
        return () -> {
            callback.run();
            BetterSprintingConfig.save();
            this.updateButtonText();
        };
    }

    private void onBindingClicked(GuiButtonInputBinding binding) {
        if (this.selectedBinding != null) {
            this.selectedBinding.setSelected(false);
        }
        this.selectedBinding = binding;
        this.selectedBinding.setSelected(true);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (super.func_231044_a_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.selectedBinding != null) {
            this.selectedBinding.setBinding(InputMappings.Type.MOUSE.func_197944_a(button));
            this.onSelectedBindingUpdated();
            return true;
        }
        return false;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.selectedBinding != null) {
            if (keyCode == 256) {
                this.selectedBinding.setBinding(KeyModifier.NONE, InputMappings.field_197958_a);
            } else {
                this.selectedBinding.setBinding(KeyModifier.getActiveModifier(), InputMappings.func_197954_a((int)keyCode, (int)scanCode));
            }
            this.onSelectedBindingUpdated();
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        if (this.selectedBinding != null) {
            this.selectedBinding.setBinding(KeyModifier.NONE, InputMappings.func_197954_a((int)keyCode, (int)scanCode));
            this.onSelectedBindingUpdated();
            return true;
        }
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    private void onSelectedBindingUpdated() {
        if (!this.selectedBinding.isSelected()) {
            this.selectedBinding = null;
        }
        for (Widget button : this.field_230710_m_) {
            if (!(button instanceof GuiButtonInputBinding)) continue;
            ((GuiButtonInputBinding)button).updateKeyBindingText();
        }
        ClientSettings.keyInfoSprintHold.readFrom(ClientModManager.keyBindSprintHold);
        ClientSettings.keyInfoSprintToggle.readFrom(ClientModManager.keyBindSprintToggle);
        ClientSettings.keyInfoSneakToggle.readFrom(ClientModManager.keyBindSneakToggle);
        ClientSettings.keyInfoOptionsMenu.readFrom(ClientModManager.keyBindOptionsMenu);
        KeyBinding.func_74508_b();
        GuiSprint.mc.field_71474_y.func_74303_b();
        BetterSprintingConfig.save();
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTickTime) {
        int top = this.field_230709_l_ / 6;
        int middle = this.field_230708_k_ / 2;
        this.func_230446_a_(matrix);
        GuiSprint.func_238472_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)middle, (int)20, (int)0xFFFFFF);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTickTime);
        int maxWidthLeft = 82;
        int maxWidthRight = 124;
        for (Widget button : this.field_230710_m_) {
            if (!(button instanceof GuiButtonCustomInput)) continue;
            GuiButtonCustomInput input = (GuiButtonCustomInput)button;
            this.drawButtonTitle(input, input.field_230690_l_ < middle ? 82 : 124);
            if (!input.func_231047_b_(mouseX, mouseY)) continue;
            ITextComponent[] spl = input.getInfo();
            for (int line = 0; line < spl.length; ++line) {
                ITextComponent iTextComponent = spl[line];
                this.field_230712_o_.getClass();
                GuiSprint.func_238472_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (ITextComponent)iTextComponent, (int)middle, (int)(top + 148 + (10 * line - 9 * spl.length / 2)), (int)-1);
            }
        }
    }

    private void drawButtonTitle(GuiButtonCustomInput btn, int maxWidth) {
        ITextComponent title = btn.getTitle();
        int lines = this.field_230712_o_.func_238425_b_((ITextProperties)title, maxWidth).size();
        this.field_230712_o_.func_238418_a_((ITextProperties)title, btn.field_230690_l_ + 76, btn.field_230691_m_ + 7 - 5 * (lines - 1), maxWidth, -1);
    }
}

