/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgiaoc.byg.core.BYGBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class BrimstoneVentsConfig
implements IFeatureConfig {
    public static final Codec<BrimstoneVentsConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)BlockStateProvider.field_236796_a_.fieldOf("block_provider").forGetter(config -> config.blockProvider), (App)BlockStateProvider.field_236796_a_.fieldOf("lava_provider").forGetter(config -> config.lavaProvider)).apply((Applicative)codecRecorder, BrimstoneVentsConfig::new));
    private final BlockStateProvider blockProvider;
    private final BlockStateProvider lavaProvider;

    BrimstoneVentsConfig(BlockStateProvider blockProvider, BlockStateProvider lavaProvider) {
        this.blockProvider = blockProvider;
        this.lavaProvider = lavaProvider;
    }

    public BlockStateProvider getBlockProvider() {
        return this.blockProvider;
    }

    public BlockStateProvider getLavaProvider() {
        return this.lavaProvider;
    }

    public static class Builder {
        private BlockStateProvider blockProvider = new SimpleBlockStateProvider(BYGBlocks.BRIMSTONE.func_176223_P());
        private BlockStateProvider lavaProvider = new SimpleBlockStateProvider(Blocks.field_150353_l.func_176223_P());

        public Builder setBlock(Block block) {
            this.blockProvider = new SimpleBlockStateProvider(block.func_176223_P());
            return this;
        }

        public Builder setBlock(BlockState state) {
            this.blockProvider = new SimpleBlockStateProvider(state);
            return this;
        }

        public Builder setLavaBlock(Block block) {
            this.lavaProvider = new SimpleBlockStateProvider(block.func_176223_P());
            return this;
        }

        public Builder setLavaBlock(BlockState state) {
            this.lavaProvider = new SimpleBlockStateProvider(state);
            return this;
        }

        public BrimstoneVentsConfig build() {
            return new BrimstoneVentsConfig(this.blockProvider, this.lavaProvider);
        }
    }
}

