/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgiaoc.byg.util.noise.fastnoise.FastNoise;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class PointyRockConfig
implements IFeatureConfig {
    public static final Codec<PointyRockConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)BlockStateProvider.field_236796_a_.fieldOf("block_provider").forGetter(config -> config.blockProvider), (App)Codec.INT.fieldOf("seed").orElse((Object)0).forGetter(config -> config.seed), (App)Codec.DOUBLE.fieldOf("height_multiplier").orElse((Object)1.0).forGetter(config -> config.heightMultiplier)).apply((Applicative)codecRecorder, PointyRockConfig::new));
    private final BlockStateProvider blockProvider;
    private final int seed;
    private final double heightMultiplier;
    private FastNoise noiseGen = null;

    PointyRockConfig(BlockStateProvider blockProvider, int seed, double heightMultiplier) {
        this.blockProvider = blockProvider;
        this.seed = seed;
        this.heightMultiplier = heightMultiplier;
    }

    public BlockStateProvider getBlockProvider() {
        return this.blockProvider;
    }

    public int getSeed() {
        return this.seed;
    }

    public double getHeightMultiplier() {
        return this.heightMultiplier;
    }

    public void setUpNoise(long worldSeed) {
        if (this.noiseGen == null) {
            this.noiseGen = new FastNoise((int)(worldSeed + (long)this.seed));
            this.noiseGen.SetFractalType(FastNoise.FractalType.RigidMulti);
            this.noiseGen.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            this.noiseGen.SetGradientPerturbAmp(5.0f);
            this.noiseGen.SetFractalOctaves(1);
            this.noiseGen.SetFractalGain(0.3f);
            this.noiseGen.SetFrequency(0.02f);
        }
    }

    public FastNoise getNoiseGen() {
        if (this.noiseGen == null) {
            throw new NullPointerException("Initialize the noiseGen variable with \"setupNoise\" in your feature!");
        }
        return this.noiseGen;
    }

    public static class Builder {
        private BlockStateProvider blockProvider = new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
        private int seed = 65;
        private double heightMultiplier = 1.0;

        public Builder setBlock(Block block) {
            this.blockProvider = new SimpleBlockStateProvider(block.func_176223_P());
            return this;
        }

        public Builder setBlock(BlockState state) {
            this.blockProvider = new SimpleBlockStateProvider(state);
            return this;
        }

        public Builder setBlock(BlockStateProvider blockProvider) {
            this.blockProvider = blockProvider;
            return this;
        }

        public Builder setSeed(int seed) {
            this.seed = seed;
            return this;
        }

        public Builder setHeightMultiplier(double heightMultiplier) {
            this.heightMultiplier = heightMultiplier;
            return this;
        }

        public PointyRockConfig build() {
            return new PointyRockConfig(this.blockProvider, this.seed, this.heightMultiplier);
        }
    }
}

