/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.overworld.river;

import corgiaoc.byg.util.noise.fastnoise.FastNoise;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;

public class RiverGenerator {
    private final List<Node> nodes;
    private final Map<ChunkPos, List<Node>> fastNodes;

    public RiverGenerator(FastNoise noise, ISeedReader world, BlockPos startPos, ChunkGenerator generator, Predicate<BlockPos> isInvalid, Predicate<BlockPos> isValid, int maxDistance) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        HashMap<ChunkPos, List<Node>> fastNodes = new HashMap<ChunkPos, List<Node>>();
        nodes.add(new Node(startPos, 0));
        int distanceInNodes = maxDistance / 5;
        int startY = startPos.func_177956_o();
        for (int i = 1; i < distanceInNodes; ++i) {
            BlockPos pos;
            Node nextNode;
            Node prevNode = (Node)nodes.get(i - 1);
            float angle = noise.GetNoise(prevNode.getPos().func_177958_n(), 0.0f, prevNode.getPos().func_177952_p());
            Vector2f dAngle = RiverGenerator.get2DAngle(angle * 5.0f, 5.0f);
            BlockPos previousNodePos = prevNode.getPos();
            Vector3i vecAngle = new Vector3i((double)dAngle.field_189982_i, 0.0, (double)dAngle.field_189983_j);
            BlockPos addedPos = previousNodePos.func_177971_a(vecAngle);
            RegistryKey biomeRegistryKey = (RegistryKey)world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_230519_c_((Object)generator.func_202090_b().func_225526_b_(addedPos.func_177958_n() >> 2, addedPos.func_177956_o() >> 2, addedPos.func_177952_p() >> 2)).get();
            int newY = generator.func_222532_b(addedPos.func_177958_n(), addedPos.func_177952_p(), Heightmap.Type.OCEAN_FLOOR_WG);
            if (newY > previousNodePos.func_177956_o()) {
                newY = previousNodePos.func_177956_o();
            }
            if (newY < generator.func_230356_f_() + 1) {
                newY = generator.func_230356_f_() + 1;
            }
            if (isInvalid.test((nextNode = new Node(pos = new BlockPos(addedPos.func_177958_n(), newY, addedPos.func_177952_p()), i)).getPos())) break;
            ChunkPos key = new ChunkPos(nextNode.getPos());
            if (isValid.test(nextNode.getPos())) {
                nodes.add(nextNode);
                fastNodes.computeIfAbsent(key, key2 -> new ArrayList()).add(nextNode);
                this.nodes = nodes;
                this.fastNodes = fastNodes;
                return;
            }
            nodes.add(nextNode);
            fastNodes.computeIfAbsent(key, key2 -> new ArrayList()).add(nextNode);
        }
        this.nodes = null;
        this.fastNodes = null;
    }

    public boolean exists() {
        return this.nodes != null;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<Node> getNodesForChunk(ChunkPos pos) {
        return this.fastNodes.get(pos);
    }

    public Set<ChunkPos> getNodeChunkPositions() {
        return this.fastNodes.keySet();
    }

    public BlockPos getFinalPosition() {
        return this.nodes.get(this.nodes.size() - 1).getPos();
    }

    public int getTotalNumberOfNodes() {
        return this.nodes.size();
    }

    public BlockPos getStartPos() {
        return this.nodes.get(0).getPos();
    }

    public static Vector2f get2DAngle(float angle, float length) {
        float x = (float)(Math.sin(angle) * (double)length);
        float y = (float)(Math.cos(angle) * (double)length);
        return new Vector2f(x, y);
    }

    static class Node {
        private final int idx;
        private BlockPos pos;

        private Node(BlockPos pos, int idx) {
            this.pos = pos;
            this.idx = idx;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public void upgradeY(int y) {
            this.pos = new BlockPos(this.pos.func_177958_n(), y, this.pos.func_177952_p());
        }

        public int getIdx() {
            return this.idx;
        }
    }
}

