/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.util;

import corgiaoc.byg.BYG;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.ref.WeakReference;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;

public class SurfaceContext {
    private static final ThreadLocal<SurfaceContext> CONTEXT = new ThreadLocal();
    private final WeakReference<ServerWorld> world;

    public SurfaceContext(ServerWorld world) {
        this.world = new WeakReference<ServerWorld>(world);
    }

    public ServerWorld getWorld() {
        return (ServerWorld)this.world.get();
    }

    @Nullable
    public static SurfaceContext pop() {
        SurfaceContext context = CONTEXT.get();
        CONTEXT.set(null);
        return context;
    }

    @Nullable
    public static SurfaceContext peek() {
        return CONTEXT.get();
    }

    public static void push(ServerWorld world, IChunk chunk) {
        if (chunk instanceof ChunkPrimer) {
            CONTEXT.set(new SurfaceContext(world));
        } else if (chunk != null) {
            BYG.LOGGER.error("ERROR: Attempted to push invalid IChunk implementation to SurfaceContext: {}", chunk.getClass());
        }
    }
}

