/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.shulkerbox;

import de.maxhenkel.shulkerbox.Events;
import de.maxhenkel.shulkerbox.ServerConfig;
import de.maxhenkel.shulkerbox.corelib.ClientRegistry;
import de.maxhenkel.shulkerbox.corelib.CommonRegistry;
import de.maxhenkel.shulkerbox.gui.ShulkerboxContainer;
import de.maxhenkel.shulkerbox.gui.ShulkerboxScreen;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="shulkerbox")
public class Main {
    public static final String MODID = "shulkerbox";
    public static ContainerType SHULKERBOX_CONTAINER;
    public static ServerConfig SERVER_CONFIG;

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(ContainerType.class, this::registerContainers);
        SERVER_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.SERVER, ServerConfig.class);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup));
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new Events());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        ClientRegistry.registerScreen(SHULKERBOX_CONTAINER, ShulkerboxScreen::new);
    }

    @SubscribeEvent
    public void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        SHULKERBOX_CONTAINER = new ContainerType((id, playerInventory) -> new ShulkerboxContainer(id, playerInventory));
        SHULKERBOX_CONTAINER.setRegistryName(new ResourceLocation(MODID, MODID));
        event.getRegistry().register((IForgeRegistryEntry)SHULKERBOX_CONTAINER);
    }
}

