/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.shulkerbox.corelib.death;

import de.maxhenkel.shulkerbox.corelib.CommonUtils;
import de.maxhenkel.shulkerbox.corelib.Logger;
import de.maxhenkel.shulkerbox.corelib.death.Death;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;

public class DeathManager {
    public static FolderName DEATHS = new FolderName("deaths");

    public static void addDeath(ServerPlayerEntity player, Death death) {
        try {
            File deathFile = DeathManager.getDeathFile(player, death.getId());
            deathFile.getParentFile().mkdirs();
            CompressedStreamTools.func_74795_b((CompoundNBT)death.toNBT(), (File)deathFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static Death getDeath(ServerPlayerEntity player, UUID id) {
        return DeathManager.getDeath(player.func_71121_q(), player.func_110124_au(), id);
    }

    @Nullable
    public static Death getDeath(ServerWorld world, UUID playerUUID, UUID id) {
        try {
            CompoundNBT data = CompressedStreamTools.func_74797_a((File)DeathManager.getDeathFile(world, playerUUID, id));
            if (data == null) {
                return null;
            }
            return Death.fromNBT(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static Death getDeath(File file) {
        try {
            CompoundNBT data = CompressedStreamTools.func_74797_a((File)file);
            if (data == null) {
                return null;
            }
            return Death.fromNBT(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static Death getDeath(ServerWorld world, UUID id) {
        File deathFolder = DeathManager.getDeathFolder(world);
        File[] players = deathFolder.listFiles((dir, name) -> name.matches("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$"));
        if (players == null) {
            return null;
        }
        for (File f : players) {
            File[] files;
            if (!f.isDirectory() || (files = f.listFiles((dir, name) -> name.equals(id.toString() + ".dat"))) == null || files.length <= 0) continue;
            return DeathManager.getDeath(world, UUID.fromString(f.getName()), id);
        }
        return null;
    }

    public static List<Death> getDeaths(ServerPlayerEntity player) {
        return DeathManager.getDeaths(player);
    }

    public static List<Death> getDeaths(ServerWorld world, UUID playerUUID) {
        File playerDeathFolder = DeathManager.getPlayerDeathFolder(world, playerUUID);
        if (!playerDeathFolder.exists()) {
            return Collections.emptyList();
        }
        File[] deaths = playerDeathFolder.listFiles((dir, name) -> name.matches("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}\\.dat$"));
        if (deaths == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(deaths).map(f -> {
            try {
                return Death.fromNBT(CompressedStreamTools.func_74797_a((File)f));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).sorted(Comparator.comparingLong(Death::getTimestamp).reversed()).collect(Collectors.toList());
    }

    public static boolean removeDeath(ServerWorld world, Death death) {
        File file = DeathManager.getDeathFile(world, death.getPlayerUUID(), death.getId());
        if (file.exists()) {
            return file.delete();
        }
        return true;
    }

    public static void removeDeathsOlderThan(ServerWorld world, long age) {
        long now = System.currentTimeMillis();
        File deathFolder = DeathManager.getDeathFolder(world);
        File[] players = deathFolder.listFiles((dir, name) -> name.matches("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$"));
        if (players == null) {
            return;
        }
        for (File f : players) {
            File[] deaths;
            if (!f.isDirectory() || (deaths = f.listFiles(file -> now - file.lastModified() > age)) == null) continue;
            for (File d : deaths) {
                Death death = DeathManager.getDeath(d);
                if (death == null || now - death.getTimestamp() <= age || !d.delete()) continue;
                Logger.INSTANCE.info("Removed death file of '{}' ({}), since it is older than {} milliseconds", (Object)death.getPlayerName(), (Object)death.getId().toString(), (Object)age);
            }
        }
    }

    public static File getDeathFile(ServerPlayerEntity player, UUID id) {
        return new File(DeathManager.getPlayerDeathFolder(player), id.toString() + ".dat");
    }

    public static File getDeathFile(ServerWorld world, UUID playerUUID, UUID id) {
        return new File(DeathManager.getPlayerDeathFolder(world, playerUUID), id.toString() + ".dat");
    }

    public static File getPlayerDeathFolder(ServerPlayerEntity player) {
        return DeathManager.getPlayerDeathFolder(player.func_71121_q(), player.func_110124_au());
    }

    public static File getPlayerDeathFolder(ServerWorld world, UUID uuid) {
        return new File(DeathManager.getDeathFolder(world), uuid.toString());
    }

    public static File getDeathFolder(ServerWorld world) {
        return CommonUtils.getWorldFolder(world, DEATHS);
    }
}

